﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Security.AccessControl;
using System.Security.Principal;

namespace gov.va.med.vbecs.Lock
{
    public class SharedMutex : IDisposable
    {
        Mutex _mutex = null;
        bool _hasHandle = false;
        private bool disposed = false;

        public void Obtain(int timeout)
        {
            try
            {
                _hasHandle = _mutex.WaitOne(timeout, false);
                if (_hasHandle == false)
                    throw new TimeoutException("Timeout waiting for exclusive access");
            }
            catch (AbandonedMutexException)
            {
                // Log the fact the mutex was abandoned in another process, it will still get aquired
                _hasHandle = true;
            }
        }

        // create mutex but do not ascire ownersheep
        public SharedMutex(string name)
        {
            if (name == null)
                throw (new ArgumentNullException("name"));

            bool created;
            _mutex = new Mutex(false, name, out created, CreateAccessSecurityForEveryone());
        }

        // create mutex but do not ascire ownersheep
        public SharedMutex(string name, out bool created)
        {
            if (name == null)
                throw (new ArgumentNullException("name"));

            _mutex = new Mutex(false, name, out created, CreateAccessSecurityForEveryone());
        }


        virtual protected MutexSecurity CreateAccessSecurityForEveryone()
        {
            var allowEveryoneRule = new MutexAccessRule(new SecurityIdentifier(WellKnownSidType.WorldSid, null), MutexRights.FullControl, AccessControlType.Allow);
            var securitySettings = new MutexSecurity();
            securitySettings.AddAccessRule(allowEveryoneRule);
            return securitySettings;
        }

        // Finalizes the instance.
        ~SharedMutex()
		{
			Dispose( false );
		}

		/// <summary>
		/// Disposes the object releasing all locks and performing the cleanup.
		/// </summary>
		public void Dispose()
		{
			GC.SuppressFinalize( this );
			Dispose( true );
		}

		protected virtual void Dispose( bool disposing )
		{				
			lock( this )
			{
                if (!disposed)
                {
				    if( disposing )
				    {
                        if (_hasHandle)
                            _mutex.ReleaseMutex();
                        if (_mutex != null)
                            _mutex.Close();
                        _mutex = null;
				    }
                    disposed = true;
                }
			}
		}		
    }
}
